* Encoding: UTF-8.

*===================================================================================*
* TTULO DE LA SINTAXIS:*
* Clculo de la Tasa de Siniestros de Trnsito por cada 1000 vehculos matriculados*
* OPERACIN ESTADSTICA:*
* Anuario de Transporte 2018 - Siniestros de Trnsito*
*DIRECCIN TCNICA RESPONSABLE:*
* Direccin de Estadsticas Econmicas (DECON)*
* ENTIDAD EJECUTORA:*
* Instituto Nacional de Estadstica y Censos (INEC)*
*===================================================================================*
* Fecha de elaboracin:        11 de Diciembre del 2018*
* Fecha ltima modificacin: 05 de Septiembre del 2019*
*===================================================================================*
* Elaborado por:*
* Unidad de Gestin de Estadsticas Estructurales (GESE)*.
* Franklin Tenesaca N.
* Gabriela Hidalgo.

*Instrucciones:.
*1.- Descarga la base de datos de Siniestros de Trnsito "2018_SINIESTROS_DE_TRANSITO_BDD" en formato SPSS de la pgina web del INEC (http://www.ecuadorencifras.gob.ec//transporte/).
*2.- Guardar y abrir la base de datos "2018_SINIESTROS_DE_TRANSITO_BDD".

DATASET NAME SINIESTROS.
DATASET COPY SINIESTROS.
DATASET  ACTIVATE SINIESTROS.

**********************************************************************************************************************.
*TASA DE SINIESTROS DE TRNSITO POR CADA MIL VEHCULOS A NIVEL PROVINCIAL***.
**********************************************************************************************************************.

***Creando variable nmero de siniestros***.
COMPUTE NST=1.
FORMATS NST (F5.0).
VARIABLE LABELS NST 'Nmero de siniestros'.
EXECUTE.

***Agregando la base de datos a nivel de provincia***.
DATASET DECLARE TASA_SINIESTROS.
AGGREGATE
  /outfile='TASA_SINIESTROS'
  /break=PROVINCIA
  /NST=SUM(NST).

**Utilizacin de la base de datos agregada***.
DATASET  ACTIVATE TASA_SINIESTROS.

***Preparando la base para el clculo del indicador***.
VARIABLE LABELS NST 'Nmero de siniestros de trnsito'.
FORMATS NST (F10.0).
EXECUTE.

IF (PROVINCIA=1) VEHICULOS=154697.
IF (PROVINCIA=2) VEHICULOS=25796.
IF (PROVINCIA=3) VEHICULOS=44620.
IF (PROVINCIA=4) VEHICULOS=23666.
IF (PROVINCIA=5) VEHICULOS=70996.
IF (PROVINCIA=6) VEHICULOS=68074.
IF (PROVINCIA=7) VEHICULOS=116063.
IF (PROVINCIA=8) VEHICULOS=45369.
IF (PROVINCIA=9) VEHICULOS=529603.
IF (PROVINCIA=10) VEHICULOS=58724.
IF (PROVINCIA=11) VEHICULOS=69424.
IF (PROVINCIA=12) VEHICULOS=131764.
IF (PROVINCIA=13) VEHICULOS=207420.
IF (PROVINCIA=14) VEHICULOS=14934.
IF (PROVINCIA=15) VEHICULOS=9379.
IF (PROVINCIA=16) VEHICULOS=11663.
IF (PROVINCIA=17) VEHICULOS=540827.
IF (PROVINCIA=18) VEHICULOS=107224.
IF (PROVINCIA=19) VEHICULOS=9989.
IF (PROVINCIA=20) VEHICULOS=2952.
IF (PROVINCIA=21) VEHICULOS=29725.
IF (PROVINCIA=22) VEHICULOS=18582.
IF (PROVINCIA=23) VEHICULOS=81253.
IF (PROVINCIA=24) VEHICULOS=30907.
EXECUTE.

VARIABLE LABELS VEHICULOS 'Vehculos Motorizados Matriculados 2018'.
FORMATS VEHICULOS (F10.0).
EXECUTE.

COMPUTE TST=(NST/(VEHICULOS/1000)).
VARIABLE LABELS TST 'Tasa de siniestros de trnsito por cada 1000 vehculos matriculados'.
FORMATS TST (F5.0).
EXECUTE.

****CUADRO N 23****.

***Tabulado: Tasa de Siniestros de Trnsito por Provincias***.
TABLES
/OBSERVATION= NST VEHICULOS TST
/TABLE= PROVINCIA BY NST + VEHICULOS+ TST
/STATISTICS=sum
/TITLE='INDICADORES SINIESTROS DE TRNSITO, ao 2018'
           'POR PROVINCIA'
           '(Nmero)'
/CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
                 'Fuente: Agencia Nacional de Trnsito - ANT 2018'.
EXECUTE.

********************************************************************************************************************.
****TASA DE SINIESTROS DE TRNSITO POR CADA MIL VEHCULOS A NIVEL NACIONAL***.
********************************************************************************************************************.

*Usando base de datos "2018_SINIESTROS_DE_TRANSITO_BDD"**.
DATASET ACTIVATE TASA_SINIESTROS.

COMPUTE TOTAL=1.
VARIABLE LABELS TOTAL 'Nacional'.
VALUE LABELS TOTAL 1'NACIONAL'.
FORMATS TOTAL (F1.0).
EXECUTE.

***Agregando la base de datos a nivel nacional***.
DATASET DECLARE TASA_SINIESTROS_N.
AGGREGATE
  /outfile='TASA_SINIESTROS_N'
  /break=TOTAL
  /NST=SUM(NST)
  /VEHICULOS=SUM(VEHICULOS).

**Utilizacin de la base de datos agregada***.
DATASET ACTIVATE TASA_SINIESTROS_N.

***Preparabdo la base para el clculo del indicador***.
VARIABLE LABELS NST 'Nmero de siniestros de trnsito'.
FORMATS NST (F10.0).
EXECUTE.

VARIABLE LABELS VEHICULOS 'Vehculos Motorizados Matriculados 2018'.
FORMATS VEHICULOS (F10.0).
EXECUTE.

COMPUTE TST=(NST/(VEHICULOS/1000)).
VARIABLE LABELS TST 'Tasa de siniestros de trnsito por cada 1000 Vehculos'.
FORMATS TST (F5.0).
EXECUTE.


****CUADRO N 23****.

***Tabulado: Tasa de Siniestros de Trnsito por Provincias***.
TABLES
/OBSERVATION= NST VEHICULOS TST
/TABLE= TOTAL BY NST + VEHICULOS+ TST
/STATISTICS=SUM
/TITLE='INDICADORES SINIESTROSDE TRNSITO, ao 2018'
           'POR PROVINCIA'
           '(Nmero)'
/CAPTION='Elaboracin: Instituto Nacional de Estadstica y Censos - INEC'
                 'Fuente: Agencia Nacional de Trnsito - ANT 2018'.
EXECUTE.


DATASET ACTIVATE SINIESTROS. 
DATASET CLOSE TASA_SINIESTROS_N.
DATASET ACTIVATE SINIESTROS. 
DATASET CLOSE TASA_SINIESTROS.






